import urllib2, json, sys, os, logging, glob
from urllib2 import Request, urlopen, URLError, HTTPError
from logging.config import fileConfig
import configparser
import time
from shutil import copyfile
from decimal import Decimal

orig_stdout = sys.stdout

config = configparser.ConfigParser()
config.read('config.ini')

serverConfiguration = config['default']
fileConfig('logging_config.ini')
logger = logging.getLogger()

lllon = serverConfiguration['lllon']
lllat = serverConfiguration['lllat']
urlon = serverConfiguration['urlon']
urlat = serverConfiguration['urlat']

deleteComplete = False

hoursForToday = 'http://' + serverConfiguration['host'] + serverConfiguration['hoursForTodayURL']
location = 'http://' + serverConfiguration['host'] + serverConfiguration['DALMPRestURL']
lastupdate = serverConfiguration.get('lastupdate', '-1')

try:
	response = urllib2.urlopen(hoursForToday)
except URLError as e:
	if hasattr(e, 'reason'):
        	logger.warning('Could not connect to the server.')
        	logger.warning('Reason: ', e.reason)
	elif hasattr(e, 'code'):
        	logger.warning('The server couldn\'t fulfill the request.')
        	logger.warning('Error code: ', e.code)
else:
	json_response = response.read()

	text = json.loads(json_response)
	gmtArr = text['hoursArrayInMillis']

	for hour in gmtArr:
		restURL = location + '&hourInMillis=' +str(hour) + '&lastUpdate=' + lastupdate
		logger.info('Processing ' + restURL)
		hourlyData_response = urllib2.urlopen(restURL)
		json_hourly_data = hourlyData_response.read()

		metricsAsJsonList = json.loads(json_hourly_data)['data']	
		if len(metricsAsJsonList) == 0:
			logger.info("No data available")
			sys.exit()

		if deleteComplete == False:
			for f in glob.glob("/var/www/contour-img/da*.png"):
				os.remove(f)
			deleteComplete = True;

		f = open('contour_da_data.py', 'w')
		sys.stdout = f

		lat_arr = []
		lng_arr = []
		val_arr = []
		
		for metrics in metricsAsJsonList:
			if "lat" in metrics:
				lat = float(metrics['lat'])
				lng = float(metrics['lng'])
				add_data = True
				if lat in lat_arr:
					index = lat_arr.index(lat)
					if(index >= 0):
						lngIn = lng_arr[index]
						if(lngIn == lng):
							#print "Found duplicate " + str(lat) + " " + str(lng)
							add_data = False
				if add_data:
					val = metrics['value']
					if( val < -10):
						val = -9.9
					if( val > 270):
						val = 270
					lat_arr.append(lat)
					lng_arr.append(lng)
					val_arr.append(val)


		print "lat = " + str(lat_arr)
		print "lng = " + str(lng_arr)
		print "value = " + str(val_arr)

		print "lllon = " + str(lllon)
		print "lllat = " + str(lllat)
		print "urlon = " + str(urlon)
		print "urlat = " + str(urlat)

		hourlyData_response.close()
		sys.stdout = orig_stdout
		f.close()

		import create_da_contour	
		reload(create_da_contour)
		fileSrc="da-contour-"+str(hour)
		create_da_contour.toFile(fileSrc)
		copyfile(fileSrc+'.png','/var/www/contour-img/'+fileSrc+'.png')

		logger.info('Saving contour to file ' + fileSrc+'.png')
		os.remove('contour_da_data.py')
		os.remove('contour_da_data.pyc')

		config['default']['lastupdate']=str(int(round(time.time() * 1000)))

		with open('config.ini', 'w') as configfile:
        		config.write(configfile)

