import numpy as np
import logging
import json
from logging.config import fileConfig
import time
import matplotlib
matplotlib.use('Agg')
from mpl_toolkits.basemap import Basemap, cm, maskoceans
from matplotlib.mlab import griddata
import matplotlib.pyplot as plt
import pandas as pd
import matplotlib.colors as clr
from matplotlib.colors import Normalize
from os.path import exists
from osgeo import gdal
from numpy import linspace
from numpy import meshgrid
from matplotlib.colors import LinearSegmentedColormap
from matplotlib.patches import Polygon,RegularPolygon
import contour_da_data as contour_data

def toFile(filename):
	reload(contour_data)
	lllon = contour_data.lllon 
	lllat = contour_data.lllat
	urlon = contour_data.urlon
	urlat = contour_data.urlat

	data = {}
	
	 # set up Basemap instance
        map = Basemap(
            projection = 'merc',
            llcrnrlon = lllon, llcrnrlat = lllat, urcrnrlon = urlon, urcrnrlat = urlat)

	iso_info = map.readshapefile('shapefiles/POLYGON',name='POLYGON',drawbounds=False)
	segs = map.POLYGON
	for nshape,seg in enumerate(segs):
		patch = Polygon(seg, facecolor='none',edgecolor='none')

	# transform lon / lat coordinates to map projection
	data['projected_lon'], data['projected_lat'] =  map(*(contour_data.lng, contour_data.lat))
	norm = Normalize()

	# grid data
	numcols, numrows = len(contour_data.lng),len(contour_data.lng)

	xi = np.linspace(min(data['projected_lon']), max(data['projected_lon']), numcols)
	yi = np.linspace(min(data['projected_lat']), max(data['projected_lat']), numrows)
	xi, yi = np.meshgrid(xi, yi)

	# interpolate
	x, y, z = data['projected_lon'], data['projected_lat'], contour_data.value 
	zi = griddata(x, y, z, xi, yi)	
	lonx, latx = map(xi, yi, inverse=True)
	zi =  maskoceans(lonx, latx, zi, resolution = 'c', grid = 10, inlands=True)

	cmap = clr.LinearSegmentedColormap.from_list("my_colormap",['#77139B','#2E3BFB','#11C0FF', '#11E0FF','#2BF5E7','#46F7C1','#68F8A3','#85FB8A','#A4FE60','#C1FC3E','#DFFE1C','#F0FF02','#F0ED01','#F0DE00','#F4C700','#F4B800','#F4A000','#F88E00','#F87D00','#F86D00','#FC5B00','#F04600','#E4360D','#D82500','#CC1000','#AA0000','#8C0000'])

	levels = np.linspace(-10, 270, 29)
	cnt = map.contourf(xi, yi, zi, levels, cmap=cmap)

	ax = plt.gca()
	ax.add_patch(patch)

	for c in cnt.collections:
	    c.set_clip_path(patch)

	plt.axis('off')

	plt.savefig(filename, dpi=1000,
		       bbox_inches='tight', 
		       transparent=True,
		       pad_inches=0, frameon=False)

	print 'Day Ahead Contour Complete ' +  filename 

