import urllib2, json, sys, logging
from urllib2 import Request, urlopen, URLError, HTTPError
from logging.config import fileConfig
import configparser
from decimal import Decimal

lat_arr = []
lng_arr = []
val_arr = []

config = configparser.ConfigParser()
config.read('config.ini')

serverConfiguration = config['default']

lllon = serverConfiguration['lllon']
lllat = serverConfiguration['lllat']
urlon = serverConfiguration['urlon']
urlat = serverConfiguration['urlat']

location = 'http://' + serverConfiguration['host'] + serverConfiguration['rtlmpresturl'] + '&lastUpdate=' + serverConfiguration.get('lastupdate', -1)
fileConfig('logging_config.ini')
logger = logging.getLogger()
logger.info('Requesting data from ' + location)

try:
        response = urllib2.urlopen(location)
except URLError as e:
        if hasattr(e, 'reason'):
                logger.warning('Could not connect to the server.')
                logger.warning('Reason: ', e.reason)
        elif hasattr(e, 'code'):
                logger.warning('The server couldn\'t fulfill the request.')
                logger.warning('Error code: ', e.code)
else:
	json_response = response.read()

	text = json.loads(json_response)
	data = text['data']

	if len(data) == 0:
		logger.info('No data available for contour')
		sys.exit()

	for metrics in data:
		if "lat" in metrics:
			lat = float(metrics['lat'])
			lng = float(metrics['lng'])
			add_data = True
			if lat in lat_arr:
				index = lat_arr.index(lat)
				if(index >= 0):
					lngIn = lng_arr[index]
					if(lngIn == lng):
						#print "Found duplicate " + str(lat) + " " + str(lng)
						add_data = False
			if add_data:		
				val = metrics['value']
				if( val < -10):
					val = -9.9
				if( val > 270):
					val = 270
				lat_arr.append(lat)
				lng_arr.append(lng)
       		       		val_arr.append(val)

	contour_data = {}
	contour_data["lat"] = lat_arr
	contour_data["lng"] = lng_arr
	contour_data["value"] = val_arr

	print "lat = " + str(lat_arr)
	print "lng = " + str(lng_arr)
	print "value = " + str(val_arr)

	print "lllon = " + str(lllon)
	print "lllat = " + str(lllat)
	print "urlon = " + str(urlon)
	print "urlat = " + str(urlat)

	response.close()
